#ifndef ZMODELER_STRUCT_DEBUGUTILS_INCLUDED
#define ZMODELER_STRUCT_DEBUGUTILS_INCLUDED

DllExport void WriteMessage(char* message);//writes text to ZModeler.log file.

//------------------------------------------------------------------
// define a DEBUG_LOG_FILENAME string with filename for debug log
#ifdef _DEBUG
  #include <stdio.h>
  extern FILE* dbgFile;//file for debug text output

  #define DEBUG_OPEN()       dbgFile = fopen(DEBUG_LOG_FILENAME, "w");
  #define DEBUG_CLOSE()      fclose(dbgFile);
  #define DEBUG_MESSAGE(fmt) fprintf(dbgFile, fmt);
  #define DEBUG_MESSAGE1(fmt,p1) fprintf(dbgFile, fmt, p1);
  #define DEBUG_MESSAGE2(fmt,p1,p2) fprintf(dbgFile, fmt, p1, p2);
  #define DEBUG_MESSAGE3(fmt,p1,p2,p3) fprintf(dbgFile, fmt, p1, p2, p3);
  #define DEBUG_MESSAGE4(fmt,p1,p2,p3,p4) fprintf(dbgFile, fmt, p1, p2, p3, p4);
#else //_DEBUG
  #define DEBUG_OPEN()                      ;
  #define DEBUG_CLOSE()                     ;
  #define DEBUG_MESSAGE(fmt)                ;
  #define DEBUG_MESSAGE1(fmt,p1)            ;
  #define DEBUG_MESSAGE2(fmt,p1,p2)         ;
  #define DEBUG_MESSAGE3(fmt,p1,p2,p3)      ;
  #define DEBUG_MESSAGE4(fmt,p1,p2,p3,p4)   ;
#endif

#endif// ZMODELER_STRUCT_DEBUGUTILS_INCLUDED
